<?php

namespace App\Helpers;

use App\Models\SettingPoint;

class PointHelper
{
    /**
     * Hitung total point dari transaksi customer.
     *
     * @param float|int $totalTransaksi
     * @return int|null Jumlah point yang didapat atau null jika tidak valid
     */
    public static function calculatePoint($totalTransaksi)
    {
        $setting = SettingPoint::first();

        if (!$setting || !$setting->status || $setting->source <= 0 || $setting->convert_to_point <= 0) {
            return null;
        }

        // Pastikan keduanya adalah float dengan 2 angka di belakang koma
        $totalTransaksi = round((float) $totalTransaksi, 2);
        $source = round((float) $setting->source, 2);

        $point = floor($totalTransaksi / $source) * $setting->convert_to_point;

        return (int) $point;
    }
}
