<?php

namespace App\Http\Controllers;

use App\Models\Cashtransaction;
use App\Models\CreditCashTransaction;
use Illuminate\Http\Request;

class CashDebtController extends Controller
{
    public function debtCashFrom(Request $request){
        $request->validate([
            'from_id' =>'required',
            'total' =>'required',
            'staff'=>'required',
            'date'=>'required',
        ]);
        
        $cash = Cashtransaction::find($request->id);
        $cash->cashout = $cash->cashout + $request->total;
        $cash->save();

        $creditCash = new CreditCashTransaction;
        $creditCash->cashtransaction_id = $cash->id;
        $creditCash->from_id = $request->from_id;
        $creditCash->total = $request->total;
        $creditCash->staff = $request->staff;
        $creditCash->date = date("Y-m-d", strtotime($request->date));
        $creditCash->save();

        $response = [
            'success'=> true,
            'cashtransaction'=>$cash,
        ];

        return response($response,200);
    }

    public function deleteCreditCashTransaction(Request $request){

        $creditCash = CreditCashTransaction::find($request->id);
        $cash = Cashtransaction::find($creditCash->cashtransaction_id);

        if ($cash->from) { // Cashout
            $cash = Cashtransaction::find($cash->id);
            $cash->cashout = $cash->cashout - $creditCash->total;
            $cash->save();
        } elseif ($cash->to){ // Cashin
            $cash = Cashtransaction::find($cash->id);
            $cash->cashin = $cash->cashin - $creditCash->total;
            $cash->save();
        }
        
        $creditCash->delete();
        
        $response = [
            'success'=>true,
            'cashtransaction'=>$cash,
        ];

        return response($response,200);
    }

    public function updateCreditCashTransaction(Request $request, $id){
        $request->validate([
            'from_id' =>'nullable',
            'total' =>'required',
            'staff'=>'required',
            'date'=>'required',
        ]);

        $creditCash = CreditCashTransaction::find($id);
        $cash = Cashtransaction::find($creditCash->cashtransaction_id);

        if ($cash->from) { // Cashout
            $cash->cashout = $cash->cashout - $creditCash->total;
            $cash->save();

            $creditCash->total = $request->total;
            $creditCash->from_id = $request->from_id;
            $creditCash->staff = $request->staff;
            $creditCash->date = date("Y-m-d", strtotime($request->date));
            $creditCash->save();

            $cash->cashout = $cash->cashout + $creditCash->total;
            $cash->save();
        } elseif ($cash->to) { // Cashin
            $cash->cashin = $cash->cashin - $creditCash->total;
            $cash->save();

            $creditCash->total = $request->total;
            $creditCash->from_id = $request->from_id;
            $creditCash->staff = $request->staff;
            $creditCash->date = date("Y-m-d", strtotime($request->date));
            $creditCash->save();

            $cash->cashin = $cash->cashin + $creditCash->total;
            $cash->save();
        }

        $response = [
            'success'=> true,
            'creditcash' => $creditCash,
            'cashtransaction' => $cash
        ];

        return response($response, 200);
    }
}
