<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Licence;
use App\Models\LicencesCompanyType;

class LicenceController extends Controller
{
    public function getLicence(Request $request)
    {
        $data = Licence::first();
        if ($data) {
            $data->company = base64_decode($data->company);

            if (!empty($data->address)) {
                $data->address = base64_decode($data->address);
            }

            if (!empty($data->phone)) {
                $data->phone = base64_decode($data->phone);
            }

            if (!empty($data->email)) {
                $data->email = base64_decode($data->email);
            }
        }
        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function createLicence(Request $request)
    {
        $request->validate([
            'licence' => 'required',
            'product_code' => 'required',
            'company' => 'required',
            'address'  => 'nullable',
            'phone'  => 'nullable',
            'email'  => 'nullable',
        ]);
        $data = Licence::whereNotNull('id')->delete();

        $CompanyType = LicencesCompanyType::first();
        $type = 'pt';
        if ($CompanyType && !empty($CompanyType->type)) {
            $type = $CompanyType->type;
        }

        $data = new Licence;
        $data->licence = $request->licence;
        $data->code = $request->product_code;
        $data->company_type = $type;
        $data->company = base64_encode($request->company);
        $data->address = base64_encode($request->address);
        $data->phone = base64_encode($request->phone);
        $data->email = base64_encode($request->email);
        $data->save();

        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function editLicence(Request $request)
    {
        $request->validate([
            'licence' => 'required',
            'product_code' => 'required',
            'company' => 'required',
            'company_type' => 'required',
            'address'  => 'nullable',
            'phone'  => 'nullable',
            'email'  => 'nullable',
        ]);

        $data = Licence::find($request->id);
        $data->licence = $request->licence;
        $data->code = $request->product_code;
        $data->company_type = $request->company_type;
        $data->company = base64_encode($request->company);
        $data->address = base64_encode($request->address);
        $data->phone = base64_encode($request->phone);
        $data->email = base64_encode($request->email);
        $data->save();

        $CompanyType = LicencesCompanyType::first();
        if ($CompanyType) {
            $CompanyType->update(['type' => $request->company_type]);
        } else {
            LicencesCompanyType::create(['type' => $request->company_type]);
        }

        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function deleteLicence(Request $request)
    {
        $data = Licence::whereNotNull('id')->delete();

        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function listCompanyType(Request $request)
    {
        $data = [
            ['id' => 1, 'name' => 'PT', 'value' => 'pt'],
            ['id' => 2, 'name' => 'CV', 'value' => 'cv'],
            // ['id' => 3, 'name' => 'YAYASAN / ORGANISASI NIRLABA', 'value' => 'yayasan'],
            ['id' => 4, 'name' => 'KOPERASI', 'value' => 'koperasi'],
            ['id' => 5, 'name' => 'PERORANGAN', 'value' => 'perorangan'],
            ['id' => 6, 'name' => 'FIRMA', 'value' => 'firma'],
            ['id' => 7, 'name' => 'BUMDES', 'value' => 'bumdes'],
            ['id' => 8, 'name' => 'LAINNYA', 'value' => 'lainnya'],
        ];

        $response = [
            'success' => true,
            'data' => $data,
        ];

        return response($response, 200);
    }
}
