<?php

namespace App\Http\Controllers;

use App\Models\PointTransaction;
use Illuminate\Http\Request;

class PointTransactionController extends Controller
{
    public function index(Request $request)
    {
        $query = PointTransaction::with('customer');

        if (!empty($request->start_date) && !empty($request->end_date)) {
            $startDate = date('Y-m-d', strtotime($request->start_date));
            $endDate = date('Y-m-d', strtotime($request->end_date));

            $query->whereBetween('date', [$startDate, $endDate]);
        }

        $data = $query->get();

        return response([
            'success' => true,
            'data' => $data
        ], 200);
    }

    public function getByCustomer(Request $request, $customerId)
    {
        $query = PointTransaction::where('customer_id', $customerId);

        if (!empty($request->start_date) && !empty($request->end_date)) {
            $startDate = date('Y-m-d', strtotime($request->start_date));
            $endDate = date('Y-m-d', strtotime($request->end_date));

            $query->whereBetween('date', [$startDate, $endDate]);
        }

        $data = $query->orderBy('date', 'desc')->get();

        return response([
            'success' => true,
            'data' => $data
        ], 200);
    }

    public function store(Request $request)
    {
        $request->validate([
            'customer_id' => 'required|exists:users,id',
            'type'        => 'required|string',
            'point'       => 'required|integer',
            'date'        => 'required|date',
            'reference'   => 'nullable|string',
            'note'        => 'nullable|string',
            'staff'       => 'required|string',
        ]);

        $transaction = new PointTransaction();
        $transaction->customer_id = $request->customer_id;
        $transaction->type        = $request->type;
        $transaction->point       = $request->point;
        $transaction->date        = $request->date;
        $transaction->reference   = $request->reference;
        $transaction->note        = $request->note;
        $transaction->staff       = $request->staff;
        $transaction->save();

        return response([
            'success' => true,
            'data' => $transaction
        ], 200);
    }

    public function show($id)
    {
        $transaction = PointTransaction::findOrFail($id);

        return response([
            'success' => true,
            'data' => $transaction
        ], 200);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'type'      => 'sometimes|required|string',
            'point'     => 'sometimes|required|integer',
            'date'      => 'sometimes|required|date',
            'reference' => 'nullable|string',
            'note'      => 'nullable|string',
            'staff'     => 'required|string',
        ]);

        $transaction = PointTransaction::findOrFail($id);

        if ($request->has('type')) {
            $transaction->type = $request->type;
        }
        if ($request->has('point')) {
            $transaction->point = $request->point;
        }
        if ($request->has('date')) {
            $transaction->date = $request->date;
        }
        if ($request->has('reference')) {
            $transaction->reference = $request->reference;
        }
        if ($request->has('note')) {
            $transaction->note = $request->note;
        }
        if ($request->has('staff')) {
            $transaction->staff = $request->staff;
        }

        $transaction->save();

        return response([
            'success' => true,
            'data' => $transaction
        ], 200);
    }

    public function destroy($id)
    {
        $transaction = PointTransaction::findOrFail($id);
        $transaction->delete();

        return response([
            'success' => true,
            'data' => null,
            'message' => 'Point transaction deleted successfully'
        ], 200);
    }
}
