<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Akun;
use App\Models\Subcashtransaction;
use App\Models\Stocktransaction;

class Cashtransaction extends Model
{
    use HasFactory;
    protected $fillable = ['*'];

    public function from(){
        return $this->belongsTo(Akun::class,'from');
    }

    public function to(){
        return $this->belongsTo(Akun::class,'to');
    }
    
    public function froms(){
        return $this->belongsTo(Akun::class,'from');
    }

    public function tos(){
        return $this->belongsTo(Akun::class,'to');
    }

    public function credit(){
        return $this->hasMany(CreditCashTransaction::class,'cashtransaction_id');
    }

    public function contact(){
        return $this->belongsTo(Contact::class,'contact_id');
    }

    public function subcashtransaction(){
        return $this->hasMany(Subcashtransaction::class,'cashtransaction_id');
    }

    public function stocktransaction()
    {
        return $this->belongsTo(Stocktransaction::class, 'stocktransaction_id');
    }

    public function getCreatedAtAttribute(){
        return \Carbon\Carbon::parse($this->attributes['created_at'])->format('Y-d-m H:i');
        }
    
    public function getUpdatedAtAttribute(){
            return \Carbon\Carbon::parse($this->attributes['updated_at'])->format('Y-d-m H:i');
        }





    
}
