<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Currency extends Model
{
    protected $table = 'currencies';

    protected $fillable = [
        'code',
        'name',
        'symbol',
        'exchange_rate',
        'locale'
    ];

    /**
     * Get the currency setting associated with this currency.
     */
    public function currencySetting()
    {
        return $this->hasOne(CurrencySetting::class);
    }
}