<?php

namespace App\Http\Controllers;

use App\Models\Language;
use Illuminate\Http\Request;

class LanguageController extends Controller
{
    public function index()
    {
        $languages = Language::all();
        return response()->json($languages);
    }

    public function show($id)
    {
        $language = Language::findOrFail($id);
        return response()->json($language);
    }

    public function getActive()
    {
        $lang = Language::where('status', true)->first();
        return response()->json($lang);
    }

    public function updateStatus(Request $request, $code)
    {
        // matikan semua dulu
        Language::query()->update(['status' => 'off']);

        // nyalakan bahasa yg dipilih
        $lang = Language::where('code', $code)->first();
        if ($lang) {
            $lang->update(['status' => 'on']);
        }

        return response()->json($lang);
    }
}
