<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $currencies = [
            // SOUTHEAST ASIAN CURRENCIES (ASEAN)
            [
                'code' => 'IDR',
                'name' => 'Indonesian Rupiah',
                'symbol' => 'Rp',
                'exchange_rate' => 1.00,
                'locale' => 'id-ID',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'SGD',
                'name' => 'Singapore Dollar',
                'symbol' => 'S$',
                'exchange_rate' => 0.000048, // Approximate rate: 1 SGD = 20,800 IDR
                'locale' => 'en-SG',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'MYR',
                'name' => 'Malaysian Ringgit',
                'symbol' => 'RM',
                'exchange_rate' => 0.000267, // Approximate rate: 1 MYR = 3,750 IDR
                'locale' => 'ms-MY',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'THB',
                'name' => 'Thai Baht',
                'symbol' => '฿',
                'exchange_rate' => 0.002174, // Approximate rate: 1 THB = 460 IDR
                'locale' => 'th-TH',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'PHP',
                'name' => 'Philippine Peso',
                'symbol' => '₱',
                'exchange_rate' => 0.001136, // Approximate rate: 1 PHP = 880 IDR
                'locale' => 'fil-PH',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'VND',
                'name' => 'Vietnamese Dong',
                'symbol' => '₫',
                'exchange_rate' => 0.002564, // Approximate rate: 1 VND = 390 IDR
                'locale' => 'vi-VN',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'BND',
                'name' => 'Brunei Dollar',
                'symbol' => 'B$',
                'exchange_rate' => 0.000048, // Approximate rate: 1 BND = 20,800 IDR (pegged to SGD)
                'locale' => 'ms-BN',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'MMK',
                'name' => 'Myanmar Kyat',
                'symbol' => 'K',
                'exchange_rate' => 0.031056, // Approximate rate: 1 MMK = 32.2 IDR
                'locale' => 'my-MM',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'LAK',
                'name' => 'Lao Kip',
                'symbol' => '₭',
                'exchange_rate' => 0.000370, // Approximate rate: 1 LAK = 2,702 IDR
                'locale' => 'lo-LA',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'KHR',
                'name' => 'Cambodian Riel',
                'symbol' => '៛',
                'exchange_rate' => 0.015625, // Approximate rate: 1 KHR = 64 IDR
                'locale' => 'km-KH',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Note: Timor-Leste uses USD which is included below
            
            // OTHER ASIAN CURRENCIES
            [
                'code' => 'JPY',
                'name' => 'Japanese Yen',
                'symbol' => '¥',
                'exchange_rate' => 0.009524, // Approximate rate: 1 JPY = 105 IDR
                'locale' => 'ja-JP',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'CNY',
                'name' => 'Chinese Yuan',
                'symbol' => '¥',
                'exchange_rate' => 0.000455, // Approximate rate: 1 CNY = 2,200 IDR
                'locale' => 'zh-CN',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'HKD',
                'name' => 'Hong Kong Dollar',
                'symbol' => 'HK$',
                'exchange_rate' => 0.000500, // Approximate rate: 1 HKD = 2,000 IDR
                'locale' => 'zh-HK',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'KRW',
                'name' => 'South Korean Won',
                'symbol' => '₩',
                'exchange_rate' => 0.048077, // Approximate rate: 1 KRW = 20.8 IDR
                'locale' => 'ko-KR',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'TWD',
                'name' => 'Taiwan Dollar',
                'symbol' => 'NT$',
                'exchange_rate' => 0.002020, // Approximate rate: 1 TWD = 495 IDR
                'locale' => 'zh-TW',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'INR',
                'name' => 'Indian Rupee',
                'symbol' => '₹',
                'exchange_rate' => 0.000765, // Approximate rate: 1 INR = 1,307 IDR
                'locale' => 'hi-IN',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'PKR',
                'name' => 'Pakistani Rupee',
                'symbol' => '₨',
                'exchange_rate' => 0.000230, // Approximate rate: 1 PKR = 4,350 IDR
                'locale' => 'ur-PK',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'BDT',
                'name' => 'Bangladeshi Taka',
                'symbol' => '৳',
                'exchange_rate' => 0.000569, // Approximate rate: 1 BDT = 1,755 IDR
                'locale' => 'bn-BD',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'NPR',
                'name' => 'Nepalese Rupee',
                'symbol' => 'रू',
                'exchange_rate' => 0.000478, // Approximate rate: 1 NPR = 2,090 IDR
                'locale' => 'ne-NP',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'LKR',
                'name' => 'Sri Lankan Rupee',
                'symbol' => 'රු',
                'exchange_rate' => 0.000206, // Approximate rate: 1 LKR = 4,850 IDR
                'locale' => 'si-LK',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            
            // GLOBAL CURRENCIES
            [
                'code' => 'USD',
                'name' => 'US Dollar',
                'symbol' => '$',
                'exchange_rate' => 0.000064, // Approximate rate: 1 USD = 15,600 IDR
                'locale' => 'en-US',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'EUR',
                'name' => 'Euro',
                'symbol' => '€',
                'exchange_rate' => 0.000059, // Approximate rate: 1 EUR = 17,000 IDR
                'locale' => 'de-DE', // Using German as default Euro locale
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'GBP',
                'name' => 'British Pound',
                'symbol' => '£',
                'exchange_rate' => 0.000051, // Approximate rate: 1 GBP = 19,600 IDR
                'locale' => 'en-GB',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'AUD',
                'name' => 'Australian Dollar',
                'symbol' => 'A$',
                'exchange_rate' => 0.000042, // Approximate rate: 1 AUD = 23,800 IDR
                'locale' => 'en-AU',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'CAD',
                'name' => 'Canadian Dollar',
                'symbol' => 'C$',
                'exchange_rate' => 0.000047, // Approximate rate: 1 CAD = 21,300 IDR
                'locale' => 'en-CA',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'CHF',
                'name' => 'Swiss Franc',
                'symbol' => 'Fr',
                'exchange_rate' => 0.000056, // Approximate rate: 1 CHF = 17,800 IDR
                'locale' => 'de-CH',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'code' => 'NZD',
                'name' => 'New Zealand Dollar',
                'symbol' => 'NZ$',
                'exchange_rate' => 0.000039, // Approximate rate: 1 NZD = 25,600 IDR
                'locale' => 'en-NZ',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($currencies as $currency) {
            $exists = DB::table('currencies')->where('code', $currency['code'])->exists();
            if (!$exists) {
                DB::table('currencies')->insert($currency);
            }
        }
    }
}