<?php

namespace App\Http\Controllers;

use App\Models\ErrorLog;
use Illuminate\Http\Request;

class ErrorLogController extends Controller
{
    public function index()
    {
        $errorLogs = ErrorLog::latest()->get();
        return response()->json(['data' => $errorLogs]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'category' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        $errorLog = ErrorLog::create($request->all());
        return response()->json(['data' => $errorLog], 201);
    }

    public function show(ErrorLog $errorLog)
    {
        return response()->json(['data' => $errorLog]);
    }

    public function update(Request $request, ErrorLog $errorLog)
    {
        $request->validate([
            'category' => 'required|string|max:255',
            'description' => 'nullable|string'
        ]);

        $errorLog->update($request->all());
        return response()->json(['data' => $errorLog]);
    }

    public function destroy(ErrorLog $errorLog)
    {
        $errorLog->delete();
        return response()->json(null, 204);
    }
}