<?php

namespace App\Http\Controllers;

use App\Models\MultiUnit;
use App\Models\Product;
use Illuminate\Http\Request;
use App\Models\Unit;
use App\Imports\UnitImport;
use Maatwebsite\Excel\Facades\Excel;

class UnitController extends Controller
{
    public function getUnit()
    {
        $data = Unit::all();

        $response = [
            'success' => true,
            'unit' => $data,
        ];

        return response($response, 200);
    }

    public function getUnitDetail(Request $request)
    {
        $data = Unit::find($request->id);

        $response = [
            'success' => true,
            'unit' => $data,
        ];

        return response($response, 200);
    }

    public function createUnit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'desc' => 'nullable',
        ]);

        $check = Unit::where('name', $request->name)->first();
        if ($check) {
            $response = [
                'success' => false,
                'message'  => 'Nama sudah dipakai',
            ];
            return response($response, 400);
        }

        $data = new Unit;
        $data->name = $request->name;
        $data->desc = $request->desc;
        $data->save();

        $response = [
            'success' => true,
            'unit' => $data,
        ];

        return response($response, 200);
    }

    public function editUnit(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'desc' => 'nullable',
        ]);

        $check = Unit::where('name', $request->name)->first();
        if ($check) {
            $response = [
                'success' => false,
                'message'  => 'Nama sudah dipakai',
            ];
            return response($response, 400);
        }

        $data = Unit::find($request->id);
        $data->name = $request->name;
        $data->desc = $request->desc;
        $data->save();

        $response = [
            'success' => true,
            'unit' => $data,
        ];

        return response($response, 200);
    }

    public function deleteUnit(Request $request)
    {

        $data = Unit::find($request->id);

        $product = Product::where('unit', $data->id)->first();
        if ($product) {
            return response([
                'message' => 'Unit ini sudah dipakai oleh ' . $product->name . ', silahkan edit/hapus dulu produk yang menggunakan unit ini.'
            ], 400);
        }
        $multiunit = MultiUnit::where('multi_unit', $data->id)
            ->orWhere('multi_sub_unit', $data->id)
            ->first();
        if ($multiunit) {
            $product = Product::find($multiunit->product_id);
            return response([
                'message' => 'Unit ini sudah dipakai oleh ' . $product->name . ', silahkan edit/hapus dulu produk yang menggunakan unit ini.'
            ], 400);
        }

        $data->delete();

        $response = [
            'success' => true,
            'unit' => $data,
        ];

        return response($response, 200);
    }

    public function bulkDeleteUnit(Request $request)
    {
        $unitIds = $request->ids;
        $skippedUnits = [];
        $deletedUnits = [];

        foreach ($unitIds as $unitId) {
            $unit = Unit::find($unitId);

            if (!$unit) {
                $skippedUnits[] = [
                    'id' => $unitId,
                    'message' => 'Unit not found',
                ];
                continue;
            }

            $product = Product::where('unit', $unitId)->first();
            if ($product) {
                $skippedUnits[] = [
                    'id' => $unitId,
                    'message' => 'Unit ini sudah dipakai oleh ' . $product->name,
                ];
                continue;
            }
            $multiunit = MultiUnit::where('multi_unit', $unitId)
                ->orWhere('multi_sub_unit', $unitId)
                ->first();
            if ($multiunit) {
                $product = Product::find($multiunit->product_id);
                $skippedUnits[] = [
                    'id' => $unitId,
                    'message' => 'Unit ini sudah dipakai oleh ' . $product->name,
                ];
                continue;
            }

            $data = Unit::find($unitId);
            $data->delete();

            $deletedUnits[] = [
                'id' => $unitId,
                'message' => 'Produk success dihapus'
            ];
        }

        $response = [
            'success' => true,
            'message' => 'Units deletion process completed',
            'data' => [
                'deleted' => [
                    'count' => count($deletedUnits),
                    'units' => $deletedUnits
                ],
                'skipped' => [
                    'count' => count($skippedUnits),
                    'units' => $skippedUnits
                ]
            ]
        ];

        return response($response, 200);
    }

    public function importUnit(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xls,xlsx'
        ]);

        $importer = new UnitImport;
        Excel::import($importer, $request->file('file'));

        return response()->json([
            'success' => true,
            'message' => 'Import process completed',
            'data' => $importer->getResults()
        ]);
    }
}
