<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Producttype;
use App\Models\Product;
use App\Models\Priceproduct;
use App\Models\Unit;
use App\Models\Substocktransaction;
use Illuminate\Support\Facades\DB;

class MultiUnit extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_id',
        'multi_unit',
        'multi_qty',
        'multi_purchase_price',
        'multi_selling_price',
        'multi_code',
        'multi_sub_unit'
    ];

    public function producttype()
    {
        return $this->belongsTo(Producttype::class, 'producttype');
    }

    public function substocktransaction()
    {
        return $this->hasMany(Substocktransaction::class, 'product_id');
    }

    public static function total()
    {
        $query = DB::table('products')
            ->select(DB::raw('sum(qty*purchase_price) as total'))
            ->first();

        return $query;
    }

    public function price()
    {
        return $this->hasMany(Priceproduct::class, 'product_id');
    }

    public function multi_unit()
    {
        return $this->belongsTo(Unit::class, 'multi_unit');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function getCreatedAtAttribute()
    {
        return \Carbon\Carbon::parse($this->attributes['created_at'])->format('Y-d-m H:i');
    }

    public function getUpdatedAtAttribute()
    {
        return \Carbon\Carbon::parse($this->attributes['updated_at'])->format('Y-d-m H:i');
    }
}
