<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PointTransaction extends Model
{
    use HasFactory;

    protected $table = 'point_transactions';

    protected $fillable = [
        'customer_id',
        'type',
        'point',
        'reference',
        'note',
        'staff',
        'date',
    ];

    // Relasi ke model Customer/Contact (jika ada)
    public function customer()
    {
        return $this->belongsTo(Contact::class, 'customer_id');
    }
}
