<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Producttype;
use App\Models\Priceproduct;
use App\Models\Unit;
use App\Models\Substocktransaction;
use Illuminate\Support\Facades\DB;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'unit',
        'purchase_price',
        'selling_price',
        'producttype',
        'code',
        'category',
        'product_image',
        'display_rack',
        'display_rack_v2',
        'qty_minimum',
        'for_sale',
        'for_purchase',
        'pricing_schema',
    ];

    public function producttype()
    {
        return $this->belongsTo(Producttype::class, 'producttype');
    }

    public function substocktransaction()
    {
        return $this->hasMany(Substocktransaction::class, 'product_id');
    }

    public static function total()
    {
        $query = DB::table('products')
            ->select(DB::raw('sum(qty*purchase_price) as total'))
            ->first();

        return $query;
    }

    public function price()
    {
        return $this->hasMany(Priceproduct::class, 'product_id');
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit');
    }

    public function multiUnits()
    {
        return $this->hasMany(MultiUnit::class, 'product_id');
    }

    public function productWholesale()
    {
        return $this->hasMany(ProductsWholesale::class, 'product_id');
    }

    public function rack()
    {
        return $this->belongsTo(ProductRack::class, 'display_rack_v2');
    }

    public function getCreatedAtAttribute()
    {
        return \Carbon\Carbon::parse($this->attributes['created_at'])->format('Y-d-m H:i');
    }

    public function getUpdatedAtAttribute()
    {
        return \Carbon\Carbon::parse($this->attributes['updated_at'])->format('Y-d-m H:i');
    }
}
