<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ColumnTranslatedCodeDecInAkuns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('akuns', function (Blueprint $table) {
            $table->string('akun_code')->unique(true)->nullable(true);
            $table->text('akun_desc')->nullable(true);
            $table->tinyText('akun_translated')->nullable(true);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('akuns', function (Blueprint $table) {
            $table->dropColumn('akun_code');
            $table->dropColumn('akun_desc');
            $table->dropColumn('akun_translated');
        });
    }
}
