<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMultiUnitAndPurchasePriceUnitAndSellingPriceUnitToSubstocktransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('substocktransactions', function (Blueprint $table) {
            $table->integer('multi_unit')->nullable()->after('selling_price');
            $table->double('qty_unit')->nullable()->after('multi_unit');
            $table->double('purchase_price_unit')->nullable()->after('qty_unit');
            $table->double('selling_price_unit')->nullable()->after('purchase_price_unit');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('substocktransactions', function (Blueprint $table) {
            $table->dropColumn(['multi_unit', 'qty_unit', 'purchase_price_unit', 'selling_price_unit']);
        });
    }
}
