<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;

class AkunsTableSelisih extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $akun1 = 'Kerugian Selisih Harga Pada Retur Pembelian';
        $akun2 = 'Keuntungan Selisih Harga Pada Retur Pembelian';
        $existing1 = DB::table('akuns')->where('name', $akun1)->first();
        if(!$existing1){
            DB::table('akuns')->insert([
                "name" => $akun1,
                "iscash" => false,
                "iscashin" => false,
                "iscashout" => false,
                "isheader" => false,
                "total" => false,
                "perent_id" => 26,
                "created_at" => Carbon::now(),
                "updated_at" => Carbon::now()
            ]);
        }
        $existing2 = DB::table('akuns')->where('name', $akun2)->first();
        if(!$existing2){
            DB::table('akuns')->insert([
                "name" => $akun2,
                "iscash" => false,
                "iscashin" => false,
                "iscashout" => false,
                "isheader" => false,
                "total" => false,
                "perent_id" => 4,
                "created_at" => Carbon::now(),
                "updated_at" => Carbon::now()
            ]);
        }
    }
}
