<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Contact;
use Carbon\Carbon;

class ContactPointsSeeder extends Seeder
{
    public function run(): void
    {
        $contacts = Contact::all();

        foreach ($contacts as $contact) {
            $exists = DB::table('contact_points')
                ->where('contact_id', $contact->id)
                ->exists();

            if (!$exists) {
                DB::table('contact_points')->insert([
                    'contact_id'    => $contact->id,
                    'total_point'   => 0,
                    'last_updated'  => Carbon::now()->format('Y-m-d'),
                    'created_at'    => Carbon::now(),
                    'updated_at'    => Carbon::now(),
                ]);
            }
        }
    }
}
