<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Language;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Indonesia (aktif)
        Language::firstOrCreate(
            ['code' => 'id'],
            [
                'name'   => 'Indonesia',
                'status' => 'on',
            ]
        );

        // English (nonaktif)
        Language::firstOrCreate(
            ['code' => 'en'],
            [
                'name'   => 'English',
                'status' => 'off',
            ]
        );
    }
}
