<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use App\Models\ContactPoint;
use App\Models\Contacttype;
use App\Models\Stocktransaction;

use Illuminate\Http\Request;
use Carbon\Carbon;

class ContactController extends Controller
{
    public function getContact()
    {
        $data = Contact::with('type')->orderBy('id', 'desc')->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactCustomer()
    {
        $data = Contact::with('type')->whereHas('type', function ($type) {
            $type->where('category', '=', 'customer');
        })->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactSupplier()
    {
        $data = Contact::with('type')->whereHas('type', function ($type) {
            $type->where('category', '=', 'supplier');
        })->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactVendor()
    {
        $data = Contact::with('type')->whereHas('type', function ($type) {
            $type->where('category', '=', 'vendor');
        })->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactKaryawan()
    {
        $data = Contact::with('type')->whereHas('type', function ($type) {
            $type->where('category', '=', 'karyawan');
        })->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactMitra()
    {
        $data = Contact::with('type')->whereHas('type', function ($type) {
            $type->where('category', '=', 'mitra');
        })->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactVendorandKaryawanMitra()
    {
        $data = Contact::with('type')->with('type')
            ->whereHas('type', function ($type) {
                $type->whereIn('category', ['vendor', 'karyawan', 'mitra']);
            })
            ->orderBy('id', 'desc')
            ->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactSales()
    {
        $data = Contact::with('type')->with('type')
            ->whereHas('type', function ($type) {
                $type->whereIn('category', ['mitra', 'karyawan']);
            })
            ->orderBy('id', 'desc')
            ->get();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function getContactDetail(Request $request)
    {
        $data = Contact::with('type')->find($request->id);

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function createContact(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'desc' => 'nullable',
            'address'  => 'nullable',
            'contact'  => 'nullable',
            'npwp'  => 'nullable',
            'bank_account_name'  => 'nullable',
            'bank_account_number'  => 'nullable',
            'type'  => 'required',
        ]);

        $data = new Contact;
        $data->name = $request->name;
        $data->desc = $request->desc;
        $data->address = $request->address;
        $data->contact = $request->contact;
        $data->contact_title = $request->contact_title;
        $data->contact_email = $request->contact_email;
        $data->type = $request->type;
        $data->npwp = $request->npwp;
        $data->bank_account_name = $request->bank_account_name;
        $data->bank_account_number = $request->bank_account_number;
        $data->save();

        // add contact point
        $contactPoint = new ContactPoint;
        $contactPoint->contact_id = $data->id;
        $contactPoint->total_point = 0;
        $contactPoint->last_updated = Carbon::now()->format('Y-m-d');
        $contactPoint->save();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function editContact(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'desc' => 'nullable',
            'address'  => 'nullable',
            'contact'  => 'nullable',
            'npwp'  => 'nullable',
            'bank_account_name'  => 'nullable',
            'bank_account_number'  => 'nullable',
            'type'  => 'required',
        ]);

        $data = Contact::find($request->id);
        $data->name = $request->name;
        $data->desc = $request->desc;
        $data->address = $request->address;
        $data->contact = $request->contact;
        $data->contact_title = $request->contact_title;
        $data->contact_email = $request->contact_email;
        $data->type = $request->type;
        $data->npwp = $request->npwp;
        $data->bank_account_name = $request->bank_account_name;
        $data->bank_account_number = $request->bank_account_number;
        $data->save();

        $response = [
            'success' => true,
            'contact' => $data,
        ];

        return response($response, 200);
    }

    public function deleteContact(Request $request)
    {

        $transaction = Stocktransaction::where('contact_id', $request->id)->get();
        if (!$transaction->isEmpty()) {
            return response(['message' => 'Contact sudah pernah digunakan untuk transaksi'], 400);
        }

        $data = Contact::find($request->id);
        $data->delete();

        $response = [
            'success' => true,
            'contact' => $data,
            'transaction' => $transaction,
        ];

        return response($response, 200);
    }
}
