<?php

namespace App\Http\Controllers;

use App\Models\InvoiceSetting;
use Illuminate\Http\Request;

class InvoiceSettingController extends Controller
{
    public function getInvoice()
    {
        $settings = InvoiceSetting::all();
        
        $response = [
            'success' => true,
            'invoice' => $settings,
        ];

        return response($response, 200);
    }

    public function getInvoiceDetail(Request $request)
    {
        $setting = InvoiceSetting::where('name', $request->name)->first();

        if (!$setting) {
            return response(['message' => 'Setting not found'], 404);
        }

        $response = [
            'success' => true,
            'invoice' => $setting,
        ];

        return response($response, 200);
    }

    public function createInvoice(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'footer_nota_wide' => 'nullable',
            'footer_sales_order' => 'nullable',
            'footer_delivery_order' => 'nullable',
        ]);

        $setting = new InvoiceSetting();
        $setting->name = $request->name;
        $setting->description = $request->description;
        $setting->footer_nota_wide = $request->footer_nota_wide;
        $setting->footer_sales_order = $request->footer_sales_order;
        $setting->footer_delivery_order = $request->footer_delivery_order;
        $setting->save();

        $response = [
            'success' => true,
            'invoice' => $setting,
        ];

        return response($response, 201);
    }

    public function updateInvoice(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'footer_nota_wide' => 'nullable',
            'footer_sales_order' => 'nullable',
            'footer_delivery_order' => 'nullable',
            'show1' => 'nullable',
            'show2' => 'nullable',
            'show3' => 'nullable',
            'show4' => 'nullable',
            'relation_1' => 'nullable',
        ]);

        $setting = InvoiceSetting::find($id);

        if (!$setting) {
            return response(['message' => 'Setting not found'], 404);
        }

        $setting->name = $request->name;
        $setting->description = $request->description;
        $setting->footer_nota_wide = $request->footer_nota_wide;
        $setting->footer_sales_order = $request->footer_sales_order;
        $setting->footer_delivery_order = $request->footer_delivery_order;
        $setting->show1 = $request->show1;
        $setting->show2 = $request->show2;
        $setting->show3 = $request->show3;
        $setting->show4 = $request->show4;
        $setting->relation_1 = $request->relation_1;

        $setting->save();

        $response = [
            'success' => true,
            'invoice' => $setting,
        ];

        return response($response, 200);
    }

    public function deleteInvoice($id)
    {
        $setting = InvoiceSetting::find($id);

        if (!$setting) {
            return response(['message' => 'Setting not found'], 404);
        }

        $setting->delete();

        $response = [
            'success' => true,
            'invoice' => 'Setting deleted successfully',
        ];

        return response($response, 200);
    }
}
