<?php

namespace App\Http\Controllers;

use App\Models\MenuSetting;
use Illuminate\Http\Request;

class MenuSettingController extends Controller
{
    public function getMenuSettings()
    {
        $menuSettings = MenuSetting::all();

        $response = [
            'success' => true,
            'menu' => $menuSettings,
        ];

        return response($response, 200);
    }

    public function updateMenuSetting(Request $request, $id)
    {
        $validated = $request->validate([
            'name' => 'required',
            'option' => 'required',
        ]);

        // Cari menu setting berdasarkan ID
        $menuSetting = MenuSetting::find($id);

        if (!$menuSetting) {
            return response()->json(['message' => 'Menu setting not found.'], 404);
        }

        // Perbarui data menggunakan save()
        $menuSetting->name = $validated['name'];
        $menuSetting->option = $validated['option'];
        $menuSetting->save();

        $response = [
            'success' => true,
            'menu' => $menuSetting,
        ];

        return response($response, 200);
    }
}
