<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attachment extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'attachment';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'cashtransaction_id',
        'stocktransaction_id',
        'file_name',
    ];

    /**
     * Get the cash transaction associated with the attachment.
     */
    public function cashTransaction()
    {
        return $this->belongsTo(Cashtransaction::class, 'cashtransaction_id');
    }

    /**
     * Get the stock transaction associated with the attachment.
     */
    public function stockTransaction()
    {
        return $this->belongsTo(Stocktransaction::class, 'stocktransaction_id');
    }
}
