<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockTransactionSo extends Model
{
    use HasFactory;

    protected $table = 'stocktransactions_so';

    protected $fillable = ['*'];

    public function signature()
    {
        return $this->belongsTo(Signature::class, 'signature_id');
    }

    public function stocktransaction()
    {
        return $this->hasMany(Stocktransaction::class, 'so_id');
    }

    public function substockopname()
    {
        return $this->hasMany(Substockopname::class, 'so_id');
    }
}
