<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('credit_cashtransactions', function (Blueprint $table) {
            $table->id();
            $table->biginteger('cashtransaction_id')->nullable();
            $table->biginteger('from_id')->nullable();
            $table->biginteger('to_id')->nullable();
            $table->double('total');
            $table->string('staff')->nullable();
            $table->date('date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('credit_cashtransactions');
    }
};