<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateDecimalColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cashtransactions', function (Blueprint $table) {
            $table->decimal('cashin', 20, 2)->change();
            $table->decimal('cashout', 20, 2)->change();
            $table->decimal('transfer', 20, 2)->change();
            $table->decimal('total', 20, 2)->change();
        });

        Schema::table('credits', function (Blueprint $table) {
            $table->decimal('total', 20, 2)->change();
        });

        Schema::table('credit_cashtransactions', function (Blueprint $table) {
            $table->decimal('total', 20, 2)->change();
        });

        Schema::table('products', function (Blueprint $table) {
            $table->decimal('purchase_price', 20, 2)->change();
            $table->decimal('selling_price', 20, 2)->change();
        });

        Schema::table('stocktransactions', function (Blueprint $table) {
            $table->decimal('total', 20, 2)->change();
            $table->decimal('paid', 20, 2)->change();
            $table->decimal('discount', 20, 2)->change();
            $table->decimal('return_credit', 20, 2)->change();
            $table->decimal('return_credit_cash', 20, 2)->change();
            $table->decimal('cash_received', 20, 2)->change();
            $table->decimal('cash_change', 20, 2)->change();
        });

        Schema::table('subcashtransactions', function (Blueprint $table) {
            $table->decimal('total', 20, 2)->change();
        });

        Schema::table('substocktransactions', function (Blueprint $table) {
            $table->decimal('hpp', 20, 2)->change();
            $table->decimal('total', 20, 2)->change();
            $table->decimal('selling_price', 20, 2)->change();
            $table->decimal('purchase_price_unit', 20, 2)->change();
            $table->decimal('selling_price_unit', 20, 2)->change();
        });

        Schema::table('contacttypes', function (Blueprint $table) {
            $table->decimal('maxdebt', 20, 2)->change();
        });

        Schema::table('multi_units', function (Blueprint $table) {
            $table->decimal('multi_purchase_price', 20, 2)->change();
            $table->decimal('multi_selling_price', 20, 2)->change();
        });

        Schema::table('priceproducts', function (Blueprint $table) {
            $table->decimal('total', 20, 2)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
