<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class ContactTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Data untuk contacttypes - Vendor
        $vendorTypeName = 'Vendor';
        $existingVendorType = DB::table('contacttypes')->where('name', $vendorTypeName)->first();

        if (!$existingVendorType) {
            $vendorTypeId = DB::table('contacttypes')->insertGetId([
                'name' => $vendorTypeName,
                'category' => 'vendor',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        } else {
            $vendorTypeId = $existingVendorType->id;
        }

        // Data untuk contacts - Vendor
        $vendorName = 'Vendor 1';
        $existingVendor = DB::table('contacts')->where('name', $vendorName)->first();

        if (!$existingVendor) {
            DB::table('contacts')->insert([
                'name' => $vendorName,
                'address' => 'Jl. Sudirman No. 123, Jakarta Pusat',
                'contact' => '822222222',
                'type' => $vendorTypeId,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }

        // Data untuk contacttypes - Karyawan
        $employeeTypeName = 'Karyawan';
        $existingEmployeeType = DB::table('contacttypes')->where('name', $employeeTypeName)->first();

        if (!$existingEmployeeType) {
            $employeeTypeId = DB::table('contacttypes')->insertGetId([
                'name' => $employeeTypeName,
                'category' => 'karyawan',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        } else {
            $employeeTypeId = $existingEmployeeType->id;
        }

        // Data untuk contacts - Karyawan
        $employeeName = 'Karyawan 1';
        $existingEmployee = DB::table('contacts')->where('name', $employeeName)->first();

        if (!$existingEmployee) {
            DB::table('contacts')->insert([
                'name' => $employeeName,
                'address' => 'Surabaya',
                'contact' => '833333333',
                'type' => $employeeTypeId,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }

        // Data untuk contacttypes - Mitra
        $mitraTypeName = 'Mitra';
        $existingMitraType = DB::table('contacttypes')->where('name', $mitraTypeName)->first();

        if (!$existingMitraType) {
            $mitraTypeId = DB::table('contacttypes')->insertGetId([
                'name' => $mitraTypeName,
                'category' => 'mitra',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        } else {
            $mitraTypeId = $existingMitraType->id;
        }

        // Data untuk contacts - Mitra
        $mitraName = 'Mitra 1';
        $existingMitra = DB::table('contacts')->where('name', $mitraName)->first();

        if (!$existingMitra) {
            DB::table('contacts')->insert([
                'name' => $mitraName,
                'address' => 'Jl. Gatot Subroto No. 456, Jakarta Selatan',
                'contact' => '844444444',
                'type' => $mitraTypeId,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }
}