<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Priceproduct;
use App\Models\MultiUnit;
use Carbon\Carbon;

class PriceproductController extends Controller
{
    public function detailProductPrice(Request $request){
        $data = Priceproduct::with('contacttype')->where('product_id',$request->id)->get();

         foreach($data as &$d) 
        { 
           $d['multi_unit'] = MultiUnit::with('multi_unit')->whereIn('id', [$d->multi_unit_id])->get();
           $d['date'] = Carbon::parse($d->created_at)->format('Y-m-d');
        }
        $response = [
            'success'=>true,
            'price'=>$data,
        ];
        
        return response($response,200);
    }
    public function cratePrice(Request $request){
        $request->validate([
            'product_id' =>'required',
            'name'  =>'nullable',
            'total'  =>'required',
            'contacttype'  =>'required',
        ]);

        $data = new Priceproduct;
        $data->product_id = $request->product_id;
        $data->name = $request->name;
        $data->total = $request->total;
        $data->multi_unit_id = $request->multi_unit_id;
        $data->contact_type = $request->contacttype;
        $data->save();

        $response = [
            'success'=>true,
            'price'=>$data,
        ];
        
        return response($response,200);
    }

    public function deletePrice(Request $request){

        $data = Priceproduct::find($request->id);
        $data->delete();
        

        $response = [
            'success'=>true,
            'price'=>$data,
        ];
        
        return response($response,200);
    }
}
