<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ContactPoint extends Model
{
    use HasFactory;

    protected $table = 'contact_points';

    protected $fillable = [
        'contact_id',
        'total_point',
        'last_updated',
    ];

    // Relasi ke model Contact (asumsikan Contact ada)
    public function contact()
    {
        return $this->belongsTo(Contact::class, 'contact_id');
    }
}
