<?php

namespace App\Http\Controllers;

use App\Models\SettingPoint;
use Illuminate\Http\Request;

class SettingPointController extends Controller
{
    // GET /setting-points
    public function index()
    {
        $data = SettingPoint::all();

        return response([
            'success' => true,
            'data' => $data,
        ], 200);
    }

    // POST /setting-points
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string',
            'source' => 'required|numeric',
            'convert_to_point' => 'required|integer',
            'status' => 'required|boolean',
        ]);

        $settingPoint = new SettingPoint();
        $settingPoint->name = $request->name;
        $settingPoint->source = $request->source;
        $settingPoint->convert_to_point = $request->convert_to_point;
        $settingPoint->status = $request->status;

        if ($settingPoint->save()) {
            return response([
                'success' => true,
                'data' => $settingPoint,
            ], 201);
        }

        return response([
            'success' => false,
            'message' => 'Failed to create setting point',
        ], 500);
    }

    // GET /setting-points/{id}
    public function show($id)
    {
        $settingPoint = SettingPoint::find($id);

        if (!$settingPoint) {
            return response([
                'success' => false,
                'message' => 'Setting point not found',
            ], 404);
        }

        return response([
            'success' => true,
            'data' => $settingPoint,
        ], 200);
    }

    // PUT /setting-points/{id}
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'sometimes|required|string',
            'source' => 'sometimes|required|numeric',
            'convert_to_point' => 'sometimes|required|integer',
            'status' => 'sometimes|required|boolean',
        ]);

        $settingPoint = SettingPoint::find($id);

        if (!$settingPoint) {
            return response([
                'success' => false,
                'message' => 'Setting point not found',
            ], 404);
        }

        $settingPoint->name = $request->name;
        $settingPoint->source = $request->source;
        $settingPoint->convert_to_point = $request->convert_to_point;
        $settingPoint->status = $request->status;

        if ($settingPoint->save()) {
            return response([
                'success' => true,
                'data' => $settingPoint,
            ], 200);
        }

        return response([
            'success' => false,
            'message' => 'Failed to update setting point',
        ], 500);
    }

    // DELETE /setting-points/{id}
    public function destroy($id)
    {
        $settingPoint = SettingPoint::find($id);

        if (!$settingPoint) {
            return response([
                'success' => false,
                'message' => 'Setting point not found',
            ], 404);
        }

        if ($settingPoint->delete()) {
            return response([
                'success' => true,
                'message' => 'Deleted successfully',
            ], 200);
        }

        return response([
            'success' => false,
            'message' => 'Failed to delete setting point',
        ], 500);
    }
}
