<?php

namespace Database\Seeders;

use App\Models\Licence;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;

class LicencesCompanyTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Ambil data pertama dari Licence
        $licence = Licence::first();

        // Tentukan nilai default untuk type
        $type = 'pt';
        if ($licence && !empty($licence->company_type)) {
            $type = $licence->company_type;
        }

        // Cek apakah data pertama sudah ada di tabel licences_company_type
        $existing = DB::table('licences_company_type')->first();

        // Jika belum ada, insert data baru
        if (!$existing) {
            DB::table('licences_company_type')->insert([
                'type' => $type,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
    }
}
