<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToInvoiceSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('invoice_setting', function (Blueprint $table) {
            $table->text('footer_nota_wide')->after('description')->nullable();
            $table->text('footer_sales_order')->after('footer_nota_wide')->nullable();
            $table->text('footer_delivery_order')->after('footer_sales_order')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('invoice_setting', function (Blueprint $table) {
            $table->dropColumn(['footer_nota_wide', 'footer_sales_order', 'footer_delivery_order']);
        });
    }
}
