<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class InvoiceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $name1 = 'footer_nota';
        $name2 = 'trans_desc';
        $name3 = 'signature_left';
        $name4 = 'signature_center';
        $name5 = 'signature_right';
        $existing1 = DB::table('invoice_setting')->where('name', $name1)->first();
        if (!$existing1) {
            DB::table('invoice_setting')->insert([
                'name' => 'footer_nota',
                'description' => 'Terimakasih atas kunjungan anda',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $existing2 = DB::table('invoice_setting')->where('name', $name2)->first();
        if (!$existing2) {
            DB::table('invoice_setting')->insert([
                'name' => 'trans_desc',
                'description' => 'no',
                'footer_nota_wide' => 'no',
                'footer_sales_order' => 'no',
                'footer_delivery_order' => 'no',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $existing3 = DB::table('invoice_setting')->where('name', $name3)->first();
        if (!$existing3) {
            DB::table('invoice_setting')->insert([
                'name' => 'signature_left',
                'show1' => 'no',
                'show2' => 'no',
                'show3' => 'no',
                'show4' => 'no',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $existing4 = DB::table('invoice_setting')->where('name', $name4)->first();
        if (!$existing4) {
            DB::table('invoice_setting')->insert([
                'name' => 'signature_center',
                'show1' => 'no',
                'show2' => 'no',
                'show3' => 'no',
                'show4' => 'no',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $existing5 = DB::table('invoice_setting')->where('name', $name5)->first();
        if (!$existing5) {
            DB::table('invoice_setting')->insert([
                'name' => 'signature_right',
                'show1' => 'yes',
                'show2' => 'yes',
                'show3' => 'yes',
                'show4' => 'yes',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
