<?php

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Akun;
use App\Models\Contact;
use App\Models\Credit;
use App\Models\Product;
use App\Models\Substocktransaction;
use App\Models\Stocktransaction;
use App\Models\Cashtransaction;
use App\Models\Subcashtransaction;
use App\Models\CreditCashTransaction;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Auth\Auth;
use App\Http\Controllers\User\RoleController;

use App\Http\Controllers\CashController;
use App\Http\Controllers\CashDebtController;
use App\Http\Controllers\AkunController;
use App\Http\Controllers\AttachmentController;
use App\Http\Controllers\BackupController;
use App\Http\Controllers\BeginningBalanceController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PriceproductController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ContacttypeController;
use App\Http\Controllers\FileUploadController;
use App\Http\Controllers\ProducttypeController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\StockDebtController;
use App\Http\Controllers\StockNonMoneyController;
use App\Http\Controllers\StockorderController;
use App\Http\Controllers\UnitController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ReportNeracaController;
use App\Http\Controllers\LicenceController;
use App\Http\Controllers\SetingcashController;
use App\Http\Controllers\ReturnController;
use App\Http\Controllers\MultiUnitController;
use App\Http\Controllers\MigrationController;
use App\Http\Controllers\ImportController;
use App\Http\Controllers\InvoiceSettingController;
use App\Http\Controllers\MenuSettingController;
use App\Http\Controllers\CurrencySettingController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\DatabaseController;
use App\Http\Controllers\CleanController;
use App\Http\Controllers\ContactPointController;
use App\Http\Controllers\SignatureController;
use App\Models\Attachment;
use Carbon\Carbon;
use App\Http\Controllers\ErrorLogController;
use App\Http\Controllers\GetController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\PointTransactionController;
use App\Http\Controllers\ProductRackController;
use App\Http\Controllers\ProductsWholesaleController;
use App\Http\Controllers\SettingPointController;
use App\Http\Controllers\StockTransactionSoController;
use App\Http\Controllers\User\ProfileController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::get('/setup/awal', function (Request $request) {
    $role = new Role;
    $role->name = 'admin';
    $role->save();


    $user = User::create([
        'name' => 'admin awal',
        'email' => 'admin@admin.com',
        'password' => bcrypt('password123'),
    ]);

    $user->syncRoles($role->name);

    return 'Ok';
});

// Api test umum 
// Role
Route::get('/role', [RoleController::class, 'getRole']);

Route::get('/cash/credit/transaction', [CashController::class, 'getCashAndCredit']);

// Auth
Route::post('/register', [Auth::class, 'register']);
Route::post('/login', [Auth::class, 'login']);

// Check User
Route::get('/check', [UserController::class, 'CheckUser']);

// Currency
Route::get('/currencies', [CurrencyController::class, 'index']);
Route::get('/currencies/{id}', [CurrencyController::class, 'show']);

// handle restore database
Route::post('/schema/database/tables/restore', [DatabaseController::class, 'executeDatabaseOperations']);

Route::get('/test', function (Request $request) {
    // $stock = Stocktransaction::first()->date;
    // $data = Carbon::create($stock)->diffForHumans();
    $data = Akun::where('iscashin', true)->first()->id;
    return $data;
});

// LANGUAGEs
Route::get('/languages', [LanguageController::class, 'index']);
Route::get('/languages/active', [LanguageController::class, 'getActive']);
Route::get('/languages/{id}', [LanguageController::class, 'show']);
Route::put('/languages/{code}', [LanguageController::class, 'updateStatus']);

Route::group(['middleware' => 'auth:sanctum'], function () {
    // Error Log
    Route::apiResource('/logs', ErrorLogController::class);

    Route::get('/logout', [Auth::class, 'logout']);
    Route::get('/clean', [CleanController::class, 'clean']); // Update route to use CleanController

    // Profile
    Route::get('/profile', [ProfileController::class, 'Profile']);
    Route::post('/profile/image', [ProfileController::class, 'setProfileImage']);
    Route::post('/profile/signature', [ProfileController::class, 'setSignatureImage']);

    // migration
    Route::post('/migrations', [MigrationController::class, 'runMigrations']);

    // handle database
    Route::post('/schema/database/tables/import', [DatabaseController::class, 'importSql']);
    Route::delete('/schema/database/tables/delete', [DatabaseController::class, 'dropAllTablesExcept']);

    // Backup
    Route::post('/backup', [BackupController::class, 'runBackup']);
    Route::get('/backup/files', [BackupController::class, 'getBackupFiles']);
    Route::get('/backup/files/{fileName}/download', [BackupController::class, 'downloadBackupFile']);
    Route::delete('/backup/files/{fileName}/delete', [BackupController::class, 'deleteBackupFile']);

    // upload file
    Route::post('/upload/file', [FileUploadController::class, 'upload']);

    // import data
    Route::post('/import/products', [ImportController::class, 'importProduct']);
    Route::post('/import/multiunit', [ImportController::class, 'importMultiUnit']);
    Route::post('/import/capital/goods', [ImportController::class, 'importCapitalGoods']);
    Route::post('/import/capital', [ImportController::class, 'importCapital']);
    Route::post('/import/stock/opname', [ImportController::class, 'importStockOpname']);

    // media route
    Route::get('/media/logo', [MediaController::class, 'getLogo']);
    Route::post('/media/logo', [MediaController::class, 'uploadLogo']);

    // Gets API
    Route::get('/get/signature/{name}', [GetController::class, 'getSignaturePosition']);

    // Currency Setting routes
    Route::get('/currency/settings', [CurrencySettingController::class, 'index']);
    Route::put('/currency/settings', [CurrencySettingController::class, 'update']);

    // attachment
    Route::post('/attachment/create', [AttachmentController::class, 'createAttachment']);
    Route::post('/attachment/edit/{id}', [AttachmentController::class, 'updateAttachment']);
    Route::get('/attachment/stock/{id}', [AttachmentController::class, 'getAttachmentsByStock']);
    Route::get('/attachment/cash/{id}', [AttachmentController::class, 'getAttachmentsByCash']);
    Route::get('/attachment/download/{id}', [AttachmentController::class, 'downloadAttachment']);
    Route::get('/attachment/all/download', [AttachmentController::class, 'downloadAllAttachments']);
    Route::delete('/attachment/delete/{id}', [AttachmentController::class, 'deleteAttachment']);

    // saldo awal
    Route::get('/beginning/balance', [BeginningBalanceController::class, 'getBeginningBalance']);
    Route::get('/beginning/balance/{type}', [BeginningBalanceController::class, 'detailBeginningBalance']);
    Route::post('/beginning/balance', [BeginningBalanceController::class, 'createBeginningBalance']);

    Route::get('/cashdata', [SetingcashController::class, 'getCashData']);

    Route::get('/licence', [LicenceController::class, 'getLicence']);
    Route::post('/licence/create', [LicenceController::class, 'createLicence']);
    Route::put('/licence/edit/{id}', [LicenceController::class, 'editLicence']);
    Route::delete('/licence/delete', [LicenceController::class, 'deleteLicence']);
    Route::get('/licence/company/type', [LicenceController::class, 'listCompanyType']);

    Route::match(['get', 'post'], '/report/{name}', [ReportController::class, 'AkunReportLaba']);
    Route::match(['get', 'post'], '/report/akun/neraca', [ReportNeracaController::class, 'AkunReportNeraca']);
    Route::match(['get', 'post'], '/report/neraca/{name}', [ReportNeracaController::class, 'AkunReportNeraca']);

    Route::get('/akun/report/{name}', [AkunController::class, 'reportName']);
    Route::get('/report', [AkunController::class, 'Report']);

    Route::get('/akun', [AkunController::class, 'getAkun']);
    Route::post('/akun/name', [AkunController::class, 'getAkunName']);
    Route::get('/akun/list/{name}', [AkunController::class, 'getAkunHead']);

    Route::get('/akun/list', [AkunController::class, 'getAkunList']);
    Route::get('/akun/iscashout', [AkunController::class, 'getAkunIsCashOut']);
    Route::get('/akun/iscashin', [AkunController::class, 'getAkunIsCashIn']);

    Route::get('/akun/iscash', [AkunController::class, 'getAkunIsCash']);
    Route::get('/akun/notcash', [AkunController::class, 'getAkunNotCash']);
    Route::get('/akun/isheader', [AkunController::class, 'getAkunIsHeader']);
    Route::post('/akun/create', [AkunController::class, 'createAkun']);
    Route::put('/akun/edit/{id}', [AkunController::class, 'editAkun']);
    Route::delete('/akun/delete/{id}', [AkunController::class, 'deleteAkun']);
    Route::post('/akun/setlaba', [AkunController::class, 'setLabaTahun']);
    Route::put('/akun/translated/{id}', [AkunController::class, 'updateAkunTranslated']);
    Route::put('/akun/translated/reset/{id}', [AkunController::class, 'resetAkunTranslated']);
    // Cash API++++

    Route::match(['get', 'post'], '/cash', [CashController::class, 'getCash']);
    Route::match(['get', 'post'], '/cash/in', [CashController::class, 'getCashIn']);
    Route::match(['get', 'post'], '/cash/out', [CashController::class, 'getCashOut']);
    Route::match(['get', 'post'], '/cash/out/page', [CashController::class, 'getCashOutPerPage']);
    Route::match(['get', 'post'], '/cash/flow', [CashController::class, 'getCashFlow']);
    Route::match(['get', 'post'], '/cash/list', [CashController::class, 'getListCashCash']);
    Route::match(['get', 'post'], '/cash/in/list', [CashController::class, 'getListCashIn']);
    Route::match(['get', 'post'], '/cash/out/list', [CashController::class, 'getListCashOut']);
    Route::match(['get', 'post'], '/cash/transfer', [CashController::class, 'getCashTransfer']);
    Route::match(['get', 'post'], '/cash/type/{type}', [CashController::class, 'getCashType']);
    Route::match(['get', 'post'], '/cash/stock/to/{id}', [CashController::class, 'getCashStockTo']);
    Route::match(['get', 'post'], '/cash/stock/from/{id}', [CashController::class, 'getCashStockFrom']);
    Route::match(['get', 'post'], '/cash/saldo-awal', [CashController::class, 'getCashSaldoAwal']);

    Route::get('/cash/transaction/detail/{id}', [CashController::class, 'getCashTransactionDetail']);

    Route::post('/cash/in/create', [CashController::class, 'createCashIn']);
    Route::post('/cash/out/create', [CashController::class, 'createCashOut']);
    Route::post('/cash/transfer/create', [CashController::class, 'createCashTransfer']);
    Route::post('/cash/create/nocash', [CashController::class, 'createCashNoCash']);

    Route::delete('/cash/transaction/delete/{id}', [CashController::class, 'deleteCashTransaction']);

    // CASH DEBT ******
    Route::put('/cash/debt/from/{id}', [CashDebtController::class, 'debtCashFrom']);
    Route::put('/cash/debt/update/{id}', [CashDebtController::class, 'updateCreditCashTransaction']);
    Route::delete('/cash/debt/delete/{id}', [CashDebtController::class, 'deleteCreditCashTransaction']);

    // UNIT API *********
    Route::match(['get', 'post'], '/unit', [UnitController::class, 'getUnit']);
    Route::post('/unit/import', [UnitController::class, 'importUnit']);

    Route::post('/unit/create', [UnitController::class, 'createUnit']);
    Route::put('/unit/edit/{id}', [UnitController::class, 'editUnit']);
    Route::delete('/unit/delete/{id}', [UnitController::class, 'deleteUnit']);
    Route::post('/unit/bulk/delete', [UnitController::class, 'bulkDeleteUnit']);

    // PRODUCT API *********
    Route::match(['get', 'post'], '/product/total', [ProductController::class, 'getProductTotal']);
    Route::match(['get', 'post'], '/product/all', [ProductController::class, 'getProductAll']);
    Route::match(['get', 'post'], '/product/all/page', [ProductController::class, 'getProductAllPerPage']);
    Route::match(['get', 'post'], '/product', [ProductController::class, 'getProduct']);
    Route::match(['get', 'post'], '/product/page', [ProductController::class, 'getProductPerPage']);
    Route::match(['get', 'post'], '/product/min/page', [ProductController::class, 'getProductMin']);
    Route::match(['get', 'post'], '/product/sale', [ProductController::class, 'getProductSale']);
    Route::match(['get', 'post'], '/product/sale/page', [ProductController::class, 'getProductSalePerPage']);
    Route::match(['get', 'post'], '/product/limit', [ProductController::class, 'getProductLimit']);
    Route::match(['get', 'post'], '/product/goods', [ProductController::class, 'getProductGoods']);
    Route::match(['get', 'post'], '/product/goods/page', [ProductController::class, 'getProductGoodsPage']);
    Route::match(['get', 'post'], '/product/price/get/{id}', [ProductController::class, 'getPriceProduct']);
    Route::match(['get', 'post'], '/product/service', [ProductController::class, 'getProductService']);

    Route::get('/product/namecode', [ProductController::class, 'getProductNameCode']);
    Route::get('/product/detail/{id}', [ProductController::class, 'getProductDetail']);

    Route::post('/product/create', [ProductController::class, 'createProduct']);
    Route::post('/product/create/limit', [ProductController::class, 'createProductLimit']);
    Route::put('/product/edit/{id}', [ProductController::class, 'editProduct']);
    Route::delete('/product/delete/{id}', [ProductController::class, 'deleteProduct']);
    Route::post('/product/bulk/delete', [ProductController::class, 'bulkDeleteProduct']);

    // PRODUCT TYPE API*********
    Route::get('/producttype', [ProducttypeController::class, 'getProducttype']);
    Route::get('/producttype/detail/{id}', [ProducttypeController::class, 'getProducttypeDetail']);
    Route::post('/producttype/detail/{id}', [ProducttypeController::class, 'getProducttypeDetail']);

    Route::post('/producttype/create', [ProducttypeController::class, 'createProducttype']);
    Route::post('/producttype/import', [ProducttypeController::class, 'importProducttype']);
    Route::put('/producttype/edit/{id}', [ProducttypeController::class, 'editProducttype']);
    Route::delete('/producttype/delete/{id}', [ProducttypeController::class, 'deleteProducttype']);

    // PRODUCT RACK
    Route::get('/product/racks', [ProductRackController::class, 'index']);
    Route::post('/product/racks/import', [ProductRackController::class, 'import']);
    Route::get('/product/racks/{id}', [ProductRackController::class, 'show']);
    Route::post('/product/racks', [ProductRackController::class, 'store']);
    Route::put('/product/racks/{id}', [ProductRackController::class, 'update']);
    Route::delete('/product/racks/{id}', [ProductRackController::class, 'destroy']);

    // Price Product.........
    Route::get('/product/price/detail/{id}', [PriceproductController::class, 'detailProductPrice']);
    Route::post('/product/price/create', [PriceproductController::class, 'cratePrice']);
    Route::delete('/product/price/delete/{id}', [PriceproductController::class, 'deletePrice']);

    // Product Wholesale
    Route::get('/product/wholesale/{id}', [ProductsWholesaleController::class, 'index']);
    Route::post('/product/wholesale/create', [ProductsWholesaleController::class, 'store']);
    Route::post('/product/wholesale/update', [ProductsWholesaleController::class, 'update']);
    Route::delete('/product/wholesale/delete/{id}', [ProductsWholesaleController::class, 'destroy']);

    // CONTACT API*********
    Route::get('/contact', [ContactController::class, 'getContact']);
    Route::post('/contact/import', [ContactController::class, 'importContact']);
    Route::get('/contact/customer', [ContactController::class, 'getContactCustomer']);
    Route::get('/contact/supplier', [ContactController::class, 'getContactSupplier']);
    Route::get('/contact/vendor', [ContactController::class, 'getContactVendor']);
    Route::get('/contact/karyawan', [ContactController::class, 'getContactKaryawan']);
    Route::get('/contact/mitra', [ContactController::class, 'getContactMitra']);
    Route::get('/contact/sales', [ContactController::class, 'getContactSales']);
    Route::get('/contact/vendor&karyawan&mitra', [ContactController::class, 'getContactVendorandKaryawanMitra']);
    Route::get('/contact/detail/{id}', [ContactController::class, 'getContactDetail']);

    Route::post('/contact/create', [ContactController::class, 'createContact']);
    Route::put('/contact/edit/{id}', [ContactController::class, 'editContact']);
    Route::delete('/contact/delete/{id}', [ContactController::class, 'deleteContact']);

    // CONTACTTYPE API*********
    Route::get('/contacttype', [ContacttypeController::class, 'getContacttype']);
    Route::get('/contacttype/detail/{id}', [ContacttypeController::class, 'getContacttypeDetail']);

    Route::post('/contacttype/create', [ContacttypeController::class, 'createContacttype']);
    Route::put('/contacttype/edit/{id}', [ContacttypeController::class, 'editContacttype']);
    Route::delete('/contacttype/delete/{id}', [ContacttypeController::class, 'deleteContacttype']);
    // STOCK REPORT ******
    Route::match(['get', 'post'], '/stock/out/report', [StockController::class, 'getStockOutReport']);

    // STOCK ******
    Route::get('/stock/transaction', [StockController::class, 'getStockTransaction']);
    Route::get('/stock/transaction/detail/{id}', [StockController::class, 'getStockTransactionDetail']);

    Route::put('/stock/transaction/update/{id}', [StockController::class, 'updateStockTransaction']);

    Route::get('/stock/out/per/sales', [StockController::class, 'getStockOutWidthSalesPerson']);

    Route::match(['get', 'post'], '/stock/in', [StockController::class, 'getStockIn']);
    Route::match(['get', 'post'], '/stock/out', [StockController::class, 'getStockOut']);
    Route::match(['get', 'post'], '/stock/retur', [StockController::class, 'getStockRetur']);
    Route::match(['get', 'post'], '/stock/retur/contact', [StockController::class, 'getUniqContactRetur']);
    Route::match(['get', 'post'], '/stock/page/in', [StockController::class, 'getStockInPage']);
    Route::match(['get', 'post'], '/stock/page/out', [StockController::class, 'getStockOutPage']);
    Route::match(['get', 'post'], '/stock/out/list', [StockController::class, 'getListStockOut']);
    Route::match(['get', 'post'], '/stock/card/list', [StockController::class, 'getCardStock']);

    Route::post('/stock/in/create', [StockController::class, 'createStockIn']);
    Route::post('/stock/out/create', [StockController::class, 'createStockOut']);

    Route::put('/stock/transaction/description/{id}', [StockController::class, 'updateDescription']);

    Route::delete('/stock/transaction/delete/{id}', [StockController::class, 'deleteStockTransaction']);

    // STOCK DEBT******
    Route::match(['get', 'post'], '/stock/out/debt', [StockDebtController::class, 'getStockOutDebt']);
    Route::match(['get', 'post'], '/stock/out/debt/due', [StockDebtController::class, 'getStockOutDebtDue']);

    Route::put('/stock/out/paid/{id}', [StockDebtController::class, 'paidStockOut']);
    Route::put('/stock/in/paid/{id}', [StockDebtController::class, 'paidStockIn']);

    Route::put('/stock/paid/update/{id}', [StockDebtController::class, 'updateCreditTransaction']);
    Route::delete('/stock/paid/delete/{id}', [StockDebtController::class, 'deleteCreditTransaction']);
    // STOCK Non Money******

    Route::get('/stock/nonmony/detail/{id}', [StockNonMoneyController::class, 'getStockTransactionDetail']);

    Route::match(['get', 'post'], '/stock/in/nonmoney', [StockNonMoneyController::class, 'getStockIn']);
    Route::match(['get', 'post'], '/stock/out/nonmoney', [StockNonMoneyController::class, 'getStockOut']);


    Route::post('/stock/in/nonmoney/create', [StockNonMoneyController::class, 'createStockIn']);
    Route::post('/stock/out/nonmoney/create', [StockNonMoneyController::class, 'createStockOut']);

    Route::delete('/stock/nonmoney/delete/{id}', [StockNonMoneyController::class, 'deleteStockTransaction']);

    // STOCK OPNAME******
    Route::match(['get', 'post'], '/stock/opname', [StockTransactionSoController::class, 'index']);
    Route::get('/stock/opname/detail/{id}', [StockTransactionSoController::class, 'show']);
    Route::post('/stock/opname/create', [StockTransactionSoController::class, 'store']);
    Route::put('/stock/opname/update/{id}', [StockTransactionSoController::class, 'update']);
    Route::delete('/stock/opname/delete/{id}', [StockTransactionSoController::class, 'destroy']);

    // STOCK Order leter******
    Route::match(['get', 'post'], '/stock/pending/out/due', [StockorderController::class, 'getStockOutDue']);
    Route::get('/stock/pending/detail/{id}', [StockorderController::class, 'getStockTransactionDetail']);

    Route::match(['get', 'post'], '/stock/pending/in', [StockorderController::class, 'getStockIn']);
    Route::match(['get', 'post'], '/stock/pending/out', [StockorderController::class, 'getStockOut']);

    Route::post('/stock/in/pending/create', [StockorderController::class, 'createStockIn']);
    Route::post('/stock/out/pending/create', [StockorderController::class, 'createStockOut']);
    Route::put('/stock/pending/update/cash/{id}', [StockorderController::class, 'updateCashOrder']);
    Route::put('/stock/pending/update/product/{id}', [StockorderController::class, 'updateProductStock']);
    Route::put('/stock/pending/update/{id}', [StockorderController::class, 'updateStockOut']);
    Route::delete('/stock/pending/delete/{id}', [StockorderController::class, 'deleteStockTransaction']);

    Route::post('/stock/pending/cancel/{id}', [StockorderController::class, 'pendingCancel']);
    Route::post('/stock/pending/refund/{id}', [StockorderController::class, 'pendingRefund']);
    Route::delete('/pending/refund/delete/{id}', [StockorderController::class, 'deleteRefund']);

    // #ROLES****
    Route::post('/role/create', [RoleController::class, 'createRole']);
    Route::put('/role/edit/{id}', [RoleController::class, 'editRole']);
    Route::delete('/role/delete/{id}', [RoleController::class, 'deleteRole']);

    Route::get('/user', [UserController::class, 'getUser']);
    Route::post('/user/role/create/{id}', [UserController::class, 'createUserRole']);
    Route::delete('/user/role/delete/{id}', [UserController::class, 'deleteUserRole']);
    Route::delete('/user/delete/{id}', [UserController::class, 'deleteUser']);

    Route::put('/user/edit/{id}', [UserController::class, 'editUser']);
    Route::put('/edit/password/{id}', [Auth::class, 'editPasswordUser']);

    // RETURN API
    Route::match(['get', 'post'], '/return/in', [ReturnController::class, 'getReturnIn']);
    Route::match(['get', 'post'], '/return/out', [ReturnController::class, 'getReturnOut']);

    Route::post('/return/in/create', [ReturnController::class, 'createReturnIn']);
    Route::post('/return/out/create', [ReturnController::class, 'createReturnOut']);

    // sedang di garap
    Route::get('/multiunit', [MultiUnitController::class, 'index']);
    Route::get('/multiunit/detail/{id}', [MultiUnitController::class, 'show']);

    Route::post('/multiunit/create', [MultiUnitController::class, 'store']);
    Route::put('/multiunit/edit/{id}', [MultiUnitController::class, 'update']);
    Route::delete('/multiunit/delete/{id}', [MultiUnitController::class, 'delete']);
    // sedang di garap

    //SETING CASH
    Route::get('/cashuser', [SetingcashController::class, 'getCash']);
    Route::post('/cashuser', [SetingcashController::class, 'createCash']);
    Route::put('/cashuser/{id}', [SetingcashController::class, 'editCash']);
    Route::delete('/cashuser/{id}', [SetingcashController::class, 'deleteCash']);

    //INVOICE
    Route::get('/setting/invoice', [InvoiceSettingController::class, 'getInvoice']);
    Route::get('/setting/invoice/{name}', [InvoiceSettingController::class, 'getInvoiceDetail']);
    Route::post('/setting/invoice', [InvoiceSettingController::class, 'createInvoice']);
    Route::put('/setting/invoice/{id}', [InvoiceSettingController::class, 'updateInvoice']);
    Route::delete('/setting/invoice/{id}', [InvoiceSettingController::class, 'deleteInvoice']);

    //MENU
    Route::get('/setting/menu', [MenuSettingController::class, 'getMenuSettings']);
    Route::put('/setting/menu/{id}', [MenuSettingController::class, 'updateMenuSetting']);

    // SIGNATURE
    Route::get('/signatures', [SignatureController::class, 'index']);
    Route::get('/signatures/{id}', [SignatureController::class, 'show']);
    Route::post('/signatures', [SignatureController::class, 'store']);
    Route::post('/signatures/{id}', [SignatureController::class, 'update']);
    Route::delete('/signatures/{id}', [SignatureController::class, 'destroy']);

    // POINTS
    Route::match(['get', 'post'], '/points', [ContactPointController::class, 'index']);
    Route::match(['get', 'post'], '/points/page', [ContactPointController::class, 'pointPage']);
    Route::post('/points/import', [ContactPointController::class, 'importPoints']);
    Route::post('/points/reset', [ContactPointController::class, 'resetAllPoints']);
    Route::put('/points/reset/{id}', [ContactPointController::class, 'resetPointPersonal']);
    Route::get('/points/{id}', [ContactPointController::class, 'show']);
    Route::put('/points/{id}', [ContactPointController::class, 'update']);

    // POINTS TRANSACTION
    Route::match(['get', 'post'], '/point-transactions', [PointTransactionController::class, 'index']);
    Route::match(['get', 'post'], '/point-transactions/customer/{customerId}', [PointTransactionController::class, 'getByCustomer']);
    Route::get('/point-transactions/{id}', [PointTransactionController::class, 'show']);
    Route::post('/point-transactions', [PointTransactionController::class, 'store']);
    Route::put('/point-transactions/{id}', [PointTransactionController::class, 'update']);
    Route::delete('/point-transactions/{id}', [PointTransactionController::class, 'destroy']);

    // SET POINTS
    Route::get('/setting-points', [SettingPointController::class, 'index']);
    Route::post('/setting-points', [SettingPointController::class, 'store']);
    Route::get('/setting-points/{id}', [SettingPointController::class, 'show']);
    Route::put('/setting-points/{id}', [SettingPointController::class, 'update']);
    Route::delete('/setting-points/{id}', [SettingPointController::class, 'destroy']);

    Route::group(['middleware' => ['role:admin']], function () {
        Route::get('/admin', function (Request $request) {
            return 'Ok';
        });
    });
    Route::group(['middleware' => ['role:admin']], function () {
        Route::get('/users/admin', function (Request $request) {
            return $request->user();
        });
    });
});
