<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTableMultiunit extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
   public function up()
    {
        if(Schema::hasTable('multi_units')) return;
        Schema::create('multi_units', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id');
            $table->integer('multi_unit');
            $table->integer('multi_sub_unit');
            $table->integer('multi_qty');
            $table->string('multi_code')->nullable();
            $table->integer('multi_purchase_price');
            $table->integer('multi_selling_price');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('multi_units');
    }
}
