<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Media;
use Illuminate\Support\Facades\Storage;

class MediaController extends Controller
{
    public function getLogo(Request $request){
        $media = Media::first();
        $image_data = null;
        if(isset($media->logo)){
            $path = $media->logo;
            $base64 = base64_encode(Storage::get($path));
            $image_data = 'data:image/png;base64,' . $base64;
        }
        $response = [
            'success'=>true,
            'logo'=> isset($image_data) ? $image_data : "",
        ];
        
        return response($response,200);
    }

    public function uploadLogo(Request $request){

        if($request->hasfile('image')){
            $path = Storage::putFileAs('media', $request->file('image'), 'logo.png');

            $media = Media::first();

            if($media){
                $media->logo = $path;
            }else{
                $media = new Media;
                $media->logo = $path;
            }

            $media->save();

            $response = [
                'success'=>true,
                'message'=> "done",
            ];

            return response($response,200);
        }else{
            $response = [
                'success' => false,
                'message' => "Silahkan upload logo"
            ];
            return response($response,400);
        }
        
    }
}
