<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
use App\Models\ProductRack;

class ProductRackController extends Controller
{
    public function index()
    {
        $racks = ProductRack::all();

        return response()->json([
            'success' => true,
            'data' => $racks
        ]);
    }

    public function show($id)
    {
        $rack = ProductRack::find($id);

        if (!$rack) {
            return response()->json([
                'success' => false,
                'message' => 'Product rack not found'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $rack
        ]);
    }

    public function store(Request $request)
    {
        $name = strtolower($request->name);

        // cek apakah sudah ada nama yang sama (case-insensitive)
        $exists = ProductRack::whereRaw('LOWER(name) = ?', [$name])->exists();

        if ($exists) {
            return response()->json([
                'success' => false,
                'message' => 'Nama rack sudah dipakai, gunakan nama lain.'
            ], 400);
        }

        $rack = new ProductRack();
        $rack->name = $request->name;
        $rack->desc = $request->desc;
        $rack->save();

        return response()->json([
            'success' => true,
            'message' => 'Product rack created successfully',
            'data' => $rack
        ]);
    }

    public function update(Request $request, $id)
    {
        $rack = ProductRack::find($id);

        if (!$rack) {
            return response()->json([
                'success' => false,
                'message' => 'Product rack not found'
            ], 404);
        }

        if ($request->has('name')) {
            $name = strtolower($request->name);

            // cek apakah nama baru bentrok dengan rack lain
            $exists = ProductRack::whereRaw('LOWER(name) = ?', [$name])
                ->where('id', '!=', $id)
                ->exists();

            if ($exists) {
                return response()->json([
                    'success' => false,
                    'message' => 'Nama rack sudah dipakai, gunakan nama lain.'
                ], 400);
            }

            $rack->name = $request->name;
        }

        if ($request->has('desc')) {
            $rack->desc = $request->desc;
        }

        $rack->save();

        return response()->json([
            'success' => true,
            'message' => 'Product rack updated successfully',
            'data' => $rack
        ]);
    }

    public function destroy($id)
    {
        $product = Product::where('display_rack_v2', $id)->first();

        if ($product) {
            return response()->json([
                'success' => false,
                'message' => 'Rak ini sedang dipakai oleh produk, tidak bisa dihapus.'
            ], 400);
        }

        $rack = ProductRack::find($id);

        if (!$rack) {
            return response()->json([
                'success' => false,
                'message' => 'Product rack not found'
            ], 404);
        }

        $rack->delete();

        return response()->json([
            'success' => true,
            'message' => 'Product rack deleted successfully'
        ]);
    }
}
