<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductsWholesale extends Model
{
    use HasFactory;

    protected $table = 'products_wholesale';

    protected $fillable = ['*'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function multiunit()
    {
        return $this->belongsTo(MultiUnit::class, 'multi_unit_id');
    }
}
