<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddReceivableIdToCashtransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cashtransactions', function (Blueprint $table) {
            $table->unsignedBigInteger('receivable_id')->nullable()->after('pay_debt_to');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cashtransactions', function (Blueprint $table) {
            $table->dropColumn('receivable_id');
        });
    }
}
