<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Licence;
use App\Models\LicencesCompanyType;
use App\Models\Language;

class LicenceController extends Controller
{
    public static function getActiveLanguage()
    {
        return Language::where('status', true)->first();
    }

    public function getLicence(Request $request)
    {
        $data = Licence::first();
        if ($data) {
            $data->company = base64_decode($data->company);

            if (!empty($data->address)) {
                $data->address = base64_decode($data->address);
            }

            if (!empty($data->phone)) {
                $data->phone = base64_decode($data->phone);
            }

            if (!empty($data->email)) {
                $data->email = base64_decode($data->email);
            }
        }
        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function createLicence(Request $request)
    {
        $request->validate([
            'licence' => 'required',
            'product_code' => 'required',
            'company' => 'required',
            'address'  => 'nullable',
            'phone'  => 'nullable',
            'email'  => 'nullable',
        ]);
        $data = Licence::whereNotNull('id')->delete();

        $CompanyType = LicencesCompanyType::first();
        $type = 'pt';
        if ($CompanyType && !empty($CompanyType->type)) {
            $type = $CompanyType->type;
        }

        $data = new Licence;
        $data->licence = $request->licence;
        $data->code = $request->product_code;
        $data->company_type = $type;
        $data->company = base64_encode($request->company);
        $data->address = base64_encode($request->address);
        $data->phone = base64_encode($request->phone);
        $data->email = base64_encode($request->email);
        $data->save();

        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function editLicence(Request $request)
    {
        $request->validate([
            'licence' => 'required',
            'product_code' => 'required',
            'company' => 'required',
            'company_type' => 'required',
            'address'  => 'nullable',
            'phone'  => 'nullable',
            'email'  => 'nullable',
        ]);

        $data = Licence::find($request->id);
        $data->licence = $request->licence;
        $data->code = $request->product_code;
        $data->company_type = $request->company_type;
        $data->company = base64_encode($request->company);
        $data->address = base64_encode($request->address);
        $data->phone = base64_encode($request->phone);
        $data->email = base64_encode($request->email);
        $data->save();

        $CompanyType = LicencesCompanyType::first();
        if ($CompanyType) {
            $CompanyType->update(['type' => $request->company_type]);
        } else {
            LicencesCompanyType::create(['type' => $request->company_type]);
        }

        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function deleteLicence(Request $request)
    {
        $data = Licence::whereNotNull('id')->delete();

        $response = [
            'success' => true,
            'licence' => $data,
        ];

        return response($response, 200);
    }

    public function listCompanyType(Request $request)
    {
        $lang = self::getActiveLanguage();
        $locale = $lang->code ?? 'id';

        $mapping = [];
        $path = config_path("lang/{$locale}/company_type.json");
        if (file_exists($path)) {
            $json = file_get_contents($path);
            $mapping = json_decode($json, true);
        }

        $raw_data = [
            ['id' => 1, 'value' => 'pt', 'default' => 'PT'],
            ['id' => 2, 'value' => 'cv', 'default' => 'CV'],
            ['id' => 3, 'value' => 'yayasan', 'default' => 'YAYASAN / ORGANISASI NIRLABA'],
            ['id' => 4, 'value' => 'koperasi', 'default' => 'KOPERASI'],
            ['id' => 5, 'value' => 'perorangan', 'default' => 'PERORANGAN'],
            ['id' => 6, 'value' => 'firma', 'default' => 'FIRMA'],
            ['id' => 7, 'value' => 'bumdes', 'default' => 'BUMDES'],
            ['id' => 8, 'value' => 'lainnya', 'default' => 'LAINNYA'],
        ];

        $data = [];
        foreach ($raw_data as $item) {
            $data[] = [
                'id' => $item['id'],
                'name' => $mapping[$item['value']] ?? $item['default'],
                'value' => $item['value']
            ];
        }

        $response = [
            'success' => true,
            'data' => $data,
        ];

        return response($response, 200);
    }
}
