<?php

namespace App\Http\Controllers;

use App\Models\Currency;
use Illuminate\Http\Request;

class CurrencyController extends Controller
{
    /**
     * Display a listing of currencies.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $currencies = Currency::all();
        $response = [
            'success' => true,
            'data' => $currencies
        ];
        return response($response, 200);
    }

    /**
     * Display the specified currency.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            $currency = Currency::findOrFail($id);
            $response = [
                'success' => true,
                'data' => $currency
            ];
            return response($response, 200);
        } catch (\Exception $e) {
            $response = [
                'success' => false,
                'message' => 'Currency not found'
            ];
            return response($response, 404);
        }
    }
}