<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\MultiUnit;
use Illuminate\Support\Facades\DB;

class MultiUnitController extends Controller
{
    //  make function crud rest api for model multiUnit
    public function index()
    {
        $products = MultiUnit::all();
        return response()->json($products);
    }

    public function show($id)
    {
        $product = MultiUnit::with('multi_unit')->whereIn('product_id', [$id])->get();
        return response()->json($product);
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'product_id' => 'required',
            'multi_unit' => 'required',
            'multi_sub_unit' => 'required',
            'multi_qty' => 'required',
            'multi_code' => 'nullable'
        ]);

        // Mulai database transaction
        DB::beginTransaction();

        try {
            $data = new MultiUnit;
            $data->multi_unit = $request->multi_unit;
            $data->multi_qty = $request->multi_qty;
            $data->multi_code = $request->multi_code;
            $data->product_id = $request->product_id;
            $data->multi_sub_unit = $request->multi_sub_unit;
            $data->multi_purchase_price = $request->multi_purchase_price;
            $data->multi_selling_price = $request->multi_selling_price;
            $data->save();

            // Commit transaction jika semua berhasil
            DB::commit();

            return response()->json($data);
        } catch (\Exception $e) {
            // Rollback transaction jika terjadi error
            DB::rollback();

            return response()->json([
                'status' => 'error',
                'message' => 'Terjadi kesalahan saat menyimpan multi unit: ' . $e->getMessage()
            ], 500);
        }
    }

    public function update(Request $request, $id)
    {
        // Mulai database transaction
        DB::beginTransaction();

        try {
            $data = MultiUnit::find($id);

            // Cek apakah multi unit exists
            if (!$data) {
                DB::rollback();
                return response()->json([
                    'status' => 'error',
                    'message' => 'Multi unit tidak ditemukan'
                ], 404);
            }

            $data->multi_unit = $request->multi_unit;
            $data->multi_qty = $request->multi_qty;
            $data->multi_code = $request->multi_code;
            $data->product_id = $request->product_id;
            $data->multi_sub_unit = $request->multi_sub_unit;
            $data->multi_purchase_price = $request->multi_purchase_price;
            $data->multi_selling_price = $request->multi_selling_price;
            $data->save();

            // Commit transaction jika semua berhasil
            DB::commit();

            return response()->json($data);
        } catch (\Exception $e) {
            // Rollback transaction jika terjadi error
            DB::rollback();

            return response()->json([
                'status' => 'error',
                'message' => 'Terjadi kesalahan saat mengupdate multi unit: ' . $e->getMessage()
            ], 500);
        }
    }

    public function delete(Request $request, $id)
    {
        $product = MultiUnit::findOrFail($id);
        $product->delete();
        return response()->json('The product was deleted successfully');
    }
}
