<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class CurrencySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the IDR currency ID
        $idrCurrency = DB::table('currencies')->where('code', 'IDR')->first();
        if ($idrCurrency) {
            $existingSetting = DB::table('currency_settings')->first();
            if (!$existingSetting) {
                DB::table('currency_settings')->insert([
                    'name' => 'currency',
                    'currency_id' => $idrCurrency->id,
                    'decimal' => ',',
                    'thousands' => '.',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
