<?php
// Fungsi untuk memuat file .env ke dalam array
function loadEnv($path) {
    if (!file_exists($path)) {
        throw new Exception(".env file not found");
    }

    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $env = [];

    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) {
            continue;
        }

        list($key, $value) = explode('=', $line, 2);
        $env[trim($key)] = trim($value);
    }

    return $env;
}

// Fungsi untuk memeriksa apakah kolom sudah ada
function columnExists($conn, $table, $column) {
    $result = $conn->query("SHOW COLUMNS FROM `$table` LIKE '$column'");
    return $result && $result->num_rows > 0;
}

try {
    // Memuat .env file yang berada di lokasi yang sama dengan file PHP ini
    $env = loadEnv(__DIR__ . '/.env');

    // Mengambil informasi koneksi database dari .env file
    $host = $env['DB_HOST'];
    $port = $env['DB_PORT'];
    $user = $env['DB_USERNAME'];
    $password = $env['DB_PASSWORD'];
    $dbname = $env['DB_DATABASE'];

    // Membuat koneksi
    $conn = new mysqli($host, $user, $password, $dbname, $port);

    // Memeriksa koneksi
    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    // SQL untuk menambahkan kolom qty_minimum di tabel products jika belum ada
    if (!columnExists($conn, 'products', 'qty_minimum')) {
        $sql1 = "ALTER TABLE `products` ADD COLUMN `qty_minimum` INT NULL";
        if ($conn->query($sql1) === TRUE) {
            echo "Kolom qty_minimum berhasil ditambahkan di tabel products.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom qty_minimum sudah ada di tabel products. Tidak perlu update.<br>";
    }

    // SQL untuk menambahkan kolom user_phone dan user_title di tabel users jika belum ada
    if (!columnExists($conn, 'users', 'user_phone')) {
        $sql2 = "ALTER TABLE `users` ADD COLUMN `user_phone` VARCHAR(255) NULL";
        if ($conn->query($sql2) === TRUE) {
            echo "Kolom user_phone berhasil ditambahkan di tabel users.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom user_phone sudah ada di tabel users. Tidak perlu update.<br>";
    }

    if (!columnExists($conn, 'users', 'user_title')) {
        $sql2 = "ALTER TABLE `users` ADD COLUMN `user_title` VARCHAR(255) NULL";
        if ($conn->query($sql2) === TRUE) {
            echo "Kolom user_title berhasil ditambahkan di tabel users.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom user_title sudah ada di tabel users. Tidak perlu update.<br>";
    }

    // SQL untuk menambahkan kolom contact_title dan contact_email di tabel contacts jika belum ada
    if (!columnExists($conn, 'contacts', 'contact_title')) {
        $sql3 = "ALTER TABLE `contacts` ADD COLUMN `contact_title` VARCHAR(255) NULL";
        if ($conn->query($sql3) === TRUE) {
            echo "Kolom contact_title berhasil ditambahkan di tabel contacts.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom contact_title sudah ada di tabel contacts. Tidak perlu update.<br>";
    }

    if (!columnExists($conn, 'contacts', 'contact_email')) {
        $sql3 = "ALTER TABLE `contacts` ADD COLUMN `contact_email` VARCHAR(255) NULL";
        if ($conn->query($sql3) === TRUE) {
            echo "Kolom contact_email berhasil ditambahkan di tabel contacts.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom contact_email sudah ada di tabel contacts. Tidak perlu update.<br>";
    }

    // SQL untuk menambahkan kolom akun_code, akun_desc, dan akun_translated di tabel akuns jika belum ada
    if (!columnExists($conn, 'akuns', 'akun_code')) {
        $sql4 = "ALTER TABLE `akuns` ADD COLUMN `akun_code` VARCHAR(255) UNIQUE NULL";
        if ($conn->query($sql4) === TRUE) {
            echo "Kolom akun_code berhasil ditambahkan di tabel akuns.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom akun_code sudah ada di tabel akuns. Tidak perlu update.<br>";
    }

    if (!columnExists($conn, 'akuns', 'akun_desc')) {
        $sql4 = "ALTER TABLE `akuns` ADD COLUMN `akun_desc` TEXT NULL";
        if ($conn->query($sql4) === TRUE) {
            echo "Kolom akun_desc berhasil ditambahkan di tabel akuns.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom akun_desc sudah ada di tabel akuns. Tidak perlu update.<br>";
    }

    if (!columnExists($conn, 'akuns', 'akun_translated')) {
        $sql4 = "ALTER TABLE `akuns` ADD COLUMN `akun_translated` TINYTEXT NULL";
        if ($conn->query($sql4) === TRUE) {
            echo "Kolom akun_translated berhasil ditambahkan di tabel akuns.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom akun_translated sudah ada di tabel akuns. Tidak perlu update.<br>";
    }

    // SQL untuk menambahkan kolom stock_attachment di tabel stocktransactions jika belum ada
    if (!columnExists($conn, 'stocktransactions', 'stock_attachment')) {
        $sql5 = "ALTER TABLE `stocktransactions` ADD COLUMN `stock_attachment` VARCHAR(255) NULL";
        if ($conn->query($sql5) === TRUE) {
            echo "Kolom stock_attachment berhasil ditambahkan di tabel stocktransactions.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom stock_attachment sudah ada di tabel stocktransactions. Tidak perlu update.<br>";
    }

    // SQL untuk menambahkan kolom cash_attachment di tabel cashtransactions jika belum ada
    if (!columnExists($conn, 'cashtransactions', 'cash_attachment')) {
        $sql6 = "ALTER TABLE `cashtransactions` ADD COLUMN `cash_attachment` VARCHAR(255) NULL";
        if ($conn->query($sql6) === TRUE) {
            echo "Kolom cash_attachment berhasil ditambahkan di tabel cashtransactions.<br>";
        } else {
            echo "Error: " . $conn->error . "<br>";
        }
    } else {
        echo "Kolom cash_attachment sudah ada di tabel cashtransactions. Tidak perlu update.<br>";
    }

    // SQL untuk menambahkan kolom for_purchase di tabel products jika belum ada
    if (!columnExists($conn, 'products', 'for_purchase')) {
        $sql7 = "ALTER TABLE `products` ADD COLUMN `for_purchase` BOOLEAN NOT NULL DEFAULT TRUE";
        if ($conn->query($sql7) === TRUE) {
            echo "Kolom for_purchase berhasil ditambahkan di tabel products.<br>";
        } else {
            echo "Error: " . $conn->error;
        }
    } else {
        echo "Kolom for_purchase sudah ada di tabel products. Tidak perlu update.<br>";
    }

    $conn->close();

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
